<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DeviceSelectResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request request
     *
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'     => $this->id,
            'name' => $this->brand->name . ' : ' . $this->name . ($this->model ? '(' . $this->model . ')' : ''),
            'avatar' => $this->getAvatar(),
        ];
    }
}
